/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.network.message;

import azmalent.terraincognita.TerraIncognita;
import azmalent.terraincognita.common.tile.ModSignTileEntity;
import azmalent.terraincognita.network.NetworkHandler;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public final class UpdateSignMessage {
    private final BlockPos pos;
    private final ITextComponent[] lines;
    private final int color;

    public UpdateSignMessage(BlockPos pos, ITextComponent[] lines, int color) {
        if (lines.length != 4) {
            throw new IllegalArgumentException("Expected 4 lines of text, got " + lines.length);
        }
        this.pos = pos;
        this.lines = lines;
        this.color = color;
    }

    public static void encode(UpdateSignMessage message, PacketBuffer buffer) {
        buffer.func_179255_a(message.pos);
        for (int i = 0; i < 4; ++i) {
            buffer.func_179256_a(message.lines[i]);
        }
        buffer.writeInt(message.color);
    }

    public static UpdateSignMessage decode(PacketBuffer buffer) {
        BlockPos pos = buffer.func_179259_c();
        ITextComponent[] lines = new ITextComponent[4];
        for (int i = 0; i < 4; ++i) {
            lines[i] = buffer.func_179258_d();
        }
        int color = buffer.readInt();
        return new UpdateSignMessage(pos, lines, color);
    }

    public static void handle(UpdateSignMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                TileEntity te;
                ServerPlayerEntity player = context.getSender();
                player.func_143004_u();
                ServerWorld world = player.func_71121_q();
                if (world.isAreaLoaded(message.pos, 1) && (te = world.func_175625_s(message.pos)) instanceof ModSignTileEntity) {
                    ModSignTileEntity sign = (ModSignTileEntity)te;
                    for (int i = 0; i < 4; ++i) {
                        sign.setText(i, message.lines[i]);
                    }
                    sign.func_70296_d();
                    sign.setTextColor(DyeColor.func_196056_a((int)message.color));
                    world.func_184138_a(message.pos, sign.func_195044_w(), sign.func_195044_w(), 3);
                    NetworkHandler.sendToAllPlayers(message);
                }
            });
        } else {
            context.enqueueWork(() -> TerraIncognita.PROXY.updateSignOnClient(message.pos, message.lines, message.color));
        }
        context.setPacketHandled(true);
    }
}

